import numpy as np
from functools import partial

def distribution(name,low=-1,high=1,std=1,beta=1,k=2,theta=2):
    '''
    usage: distribution(name)(size=size)
    '''
    if name=='uniform':
        funct = partial(np.random.uniform,low=low,high=high)
    elif name=='gaussian':
        funct = partial(np.random.normal,loc=0,scale=std)
    elif name=='exponential':
        funct = partial(np.random.exponential,scale=beta)
    elif name=='gamma':
        funct = partial(np.random.gamma,shape=k,scale=theta)
    else:
        raise ValueError('Only support uniform,gaussian,exponential,gamma distribution.')
    return funct


def function(name,alpha=1.0):
    '''
    usage: y = function(name)(x); 1.0 for smoothness, 2.5 for less smoothness
    '''
    if name=='linear':
        funct = lambda x:alpha*0.2*x
    elif name=='sin':
        funct = lambda x:alpha*0.5*(np.sin(np.pi/8*x)+1)
    elif name=='tanh':
        funct = lambda x:alpha*0.5*(np.tanh(x)+1)
    elif name=='sigmoid':
        funct = lambda x: alpha*1.0/(1.0+np.exp(-x))
    else:
        raise ValueError('Only support linear,sin,tanh,sigmoid function.')
    return funct

